from __future__ import annotations

from aiohttp import ClientSession

from ..typing       import AsyncResult, Messages
from .base_provider import AsyncGeneratorProvider


class ChatBase(AsyncGeneratorProvider):
    url = "https://www.chatbase.co"
    supports_gpt_35_turbo = True
    supports_message_history = True
    working = True
    list_incorrect_responses = ["support@chatbase", "about Chatbase"]

    @classmethod
    async def create_async_generator(
        cls,
        model: str,
        messages: Messages,
        proxy: str = None,
        **kwargs
    ) -> AsyncResult:
        chat_id = 'z2c2HSfKnCTh5J4650V0I'

        headers = {
            "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/116.0.0.0 Safari/537.36",
            "Accept": "*/*",
            "Accept-language": "en,fr-FR;q=0.9,fr;q=0.8,es-ES;q=0.7,es;q=0.6,en-US;q=0.5,am;q=0.4,de;q=0.3",
            "Origin": cls.url,
            "Referer": f"{cls.url}/",
            "Sec-Fetch-Dest": "empty",
            "Sec-Fetch-Mode": "cors",
            "Sec-Fetch-Site": "same-origin",
        }
        async with ClientSession(headers=headers) as session:
            data = {
                "messages": messages,
                "captchaCode": "hadsa",
                "chatId": chat_id,
                "conversationId": f"kcXpqEnqUie3dnJlsRi_O-{chat_id}"
            }

            async with session.post("https://www.chatbase.co/api/fe/chat", json=data, proxy=proxy) as response:
                response.raise_for_status()
                response_data = ""
                async for stream in response.content.iter_any():
                    response_data += stream.decode()
                    for incorrect_response in cls.list_incorrect_responses:
                        if incorrect_response in response_data:
                            raise RuntimeError("Incorrect response")
                    yield stream.decode()

    @classmethod
    @property
    def params(cls):
        params = [
            ("model", "str"),
            ("messages", "list[dict[str, str]]"),
            ("stream", "bool"),
        ]
        param = ", ".join([": ".join(p) for p in params])
        return f"g4f.provider.{cls.__name__} supports: ({param})"
